<?php

namespace LVR\CreditCard\Tests\Unit\Cards;

use Illuminate\Support\Collection;
use LVR\CreditCard\Cards\AmericanExpress;

class AmericanExpressTest extends BaseCardTests
{
    public $instance = AmericanExpress::class;

    /**
     * @return \Illuminate\Support\Collection
     */
    public function validNumbers(): Collection
    {
        return collect([
            '370218180742397',
            '372397607726296',
            '372482095016127',
            '341654131598940',
            '342092383097700',
            '371402651431602',
            '373999470893076',
            '348191837276326',
            '376197788590172',
            '346194337569648',
            '377951329307689',
            '372415734651649',
            '373613056412512',
            '375288451660755',
            '376713785956958',
            '378058657531895',
            '348912094040554',
            '372768635162284',
            '346632468550770',
            '373685521521341',
            '375817754841348',
            '348966851780083',
            '347777522125421',
            '349082365069846',
            '343916697911348',
            '378520082867194',
            '347984305466671',
            '342685147120427',
            '340723981791862',
            '344817514023771',
            '342830796835509',
            '376069266668582',
            '376764385401200',
            '347152446306285',
            '344167801647183',
            '345308889956950',
            '348929599720209',
            '375644109378390',
            '348018790892650',
            '373991218892163',
            '371551085600776',
            '345447498250353',
            '344699158855845',
            '348154855484768',
            '349310688749657',
            '343652760053599',
            '348242338160863',
            '347752311305534',
            '374854187267040',
            '346486972534774',
            '379057933755426',
            '373627072029043',
            '346631500015479',
            '340569944549800',
            '348936046052318',
            '373631870860500',
            '340566993941557',
            '372290680943765',
            '370988386537367',
            '376208080529196',
            '373210001669526',
            '371512577090827',
            '347101108902352',
            '371462891308242',
            '372265190766732',
            '370197060112618',
            '349195302314545',
            '373802665267819',
            '370038047911864',
            '374950557820507',
            '349071148275796',
            '344553938560946',
            '343638174522543',
            '377155214180231',
            '370216480733827',
            '371720652370978',
            '373834919037706',
            '344711733496084',
            '346294472746199',
            '340779737476067',
            '342666765564286',
            '376611714089927',
            '340367730803196',
            '346003788945886',
            '374720528028716',
            '344653599831055',
            '370822632101621',
            '371612917183975',
            '374227887630736',
            '344701087539670',
            '378639972955453',
            '379883538029093',
            '345046751534089',
            '349618294754790',
            '375308525244178',
            '378673342630082',
            '370586993845650',
            '344566883297843',
            '379811393604866',
            '378167408666270',
            '3455555555555504',
        ]);
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function numbersWithInvalidLength(): Collection
    {
        return collect([
            '3782822',
            '37144963539843100',
            '37873449367100',
        ]);
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function numbersWithInvalidCheckSum(): Collection
    {
        return collect([
            '378282246310001',
            '371449635398432',
            '378734493671001',
        ]);
    }
}
