<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>John Housing - Your Trusted Real Estate Partner</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary: #2c5aa0;
            --secondary: #e63946;
            --accent: #ffb347;
            --dark: #2c3e50;
            --light: #f8f9fa;
            --success: #2ecc71;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
            overflow-x: hidden;
        }

        .navbar {
            background-color: white;
            box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
            transition: all 0.3s ease;
        }

        .navbar-brand {
            font-weight: 800;
            font-size: 1.8rem;
            color: var(--primary) !important;
        }

        .navbar-brand span {
            color: var(--secondary);
        }

        .nav-link {
            color: var(--dark) !important;
            font-weight: 600;
            margin: 0 10px;
            transition: color 0.3s;
        }

        .nav-link:hover {
            color: var(--primary) !important;
        }

        .hero-section {
            background: linear-gradient(rgba(44, 90, 160, 0.85), rgba(44, 90, 160, 0.8)),
            url('https://images.pexels.com/photos/1396132/pexels-photo-1396132.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2');
            background-size: cover;
            background-position: center;
            color: white;
            padding: 180px 0 100px;
            text-align: center;
        }

        .hero-title {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 20px;
            text-shadow: 2px 2px 8px rgba(0, 0, 0, 0.3);
        }

        .hero-subtitle {
            font-size: 1.5rem;
            margin-bottom: 30px;
            max-width: 700px;
            margin-left: auto;
            margin-right: auto;
            opacity: 0.9;
        }

        .btn-primary-custom {
            background-color: var(--primary);
            border: none;
            padding: 14px 35px;
            font-weight: 600;
            border-radius: 8px;
            transition: all 0.3s;
            color: white;
        }

        .btn-primary-custom:hover {
            background-color: #1e3d6f;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(44, 90, 160, 0.3);
            color: white;
        }

        .btn-secondary-custom {
            background-color: var(--secondary);
            border: none;
            padding: 14px 35px;
            font-weight: 600;
            border-radius: 8px;
            transition: all 0.3s;
            color: white;
        }

        .btn-secondary-custom:hover {
            background-color: #c1121f;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(230, 57, 70, 0.3);
            color: white;
        }

        .section-title {
            font-weight: 800;
            margin-bottom: 50px;
            position: relative;
            display: inline-block;
            color: var(--dark);
        }

        .section-title:after {
            content: '';
            position: absolute;
            width: 70%;
            height: 4px;
            background: linear-gradient(to right, var(--primary), var(--accent));
            bottom: -10px;
            left: 15%;
        }

        .about-section {
            padding: 100px 0;
            background-color: var(--light);
        }

        .services-section {
            padding: 100px 0;
            background-color: white;
        }

        .service-card {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: all 0.3s;
            margin-bottom: 30px;
            height: 100%;
            border: 1px solid #e9ecef;
        }

        .service-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
            border-color: var(--primary);
        }

        .service-icon {
            font-size: 3rem;
            color: var(--primary);
            margin-bottom: 20px;
            background: rgba(44, 90, 160, 0.1);
            width: 80px;
            height: 80px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
        }

        .properties-section {
            padding: 80px 0;
            background: linear-gradient(135deg, #f5f7fa 0%, #e4e8f0 100%);
        }

        .property-card {
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: all 0.3s;
            margin-bottom: 30px;
            background: white;
        }

        .property-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }

        .property-img {
            height: 220px;
            width: 100%;
            object-fit: cover;
        }

        .property-price {
            color: var(--primary);
            font-weight: 800;
            font-size: 1.5rem;
        }

        .property-feature {
            color: #6c757d;
            font-size: 0.9rem;
        }

        .history-section {
            padding: 100px 0;
            background-color: var(--dark);
            color: white;
        }

        .history-timeline {
            position: relative;
            max-width: 1000px;
            margin: 0 auto;
        }

        .history-timeline:before {
            content: '';
            position: absolute;
            width: 4px;
            background-color: var(--accent);
            top: 0;
            bottom: 0;
            left: 50%;
            margin-left: -2px;
        }

        .history-item {
            padding: 20px 40px;
            position: relative;
            width: 50%;
            box-sizing: border-box;
        }

        .history-item:nth-child(odd) {
            left: 0;
            text-align: right;
        }

        .history-item:nth-child(even) {
            left: 50%;
        }

        .history-item:after {
            content: '';
            position: absolute;
            width: 20px;
            height: 20px;
            background-color: var(--primary);
            border: 4px solid var(--accent);
            top: 25px;
            border-radius: 50%;
            z-index: 1;
        }

        .history-item:nth-child(odd):after {
            right: -12px;
        }

        .history-item:nth-child(even):after {
            left: -12px;
        }

        .history-content {
            padding: 20px;
            background-color: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            backdrop-filter: blur(10px);
        }

        .year-badge {
            background-color: var(--accent);
            color: var(--dark);
            font-weight: 700;
            padding: 5px 15px;
            border-radius: 20px;
            display: inline-block;
            margin-bottom: 10px;
        }

        .testimonials-section {
            padding: 100px 0;
            background-color: var(--light);
        }

        .testimonial-card {
            background: white;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            margin-bottom: 30px;
            transition: all 0.3s;
            border-left: 5px solid var(--primary);
        }

        .testimonial-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }

        .testimonial-img {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            object-fit: cover;
            margin-bottom: 20px;
            border: 3px solid var(--accent);
        }

        .testimonial-text {
            font-style: italic;
            margin-bottom: 20px;
            position: relative;
        }

        .testimonial-text:before {
            content: '"';
            font-size: 4rem;
            color: var(--primary);
            position: absolute;
            left: -15px;
            top: -25px;
            opacity: 0.2;
        }

        .contact-section {
            padding: 100px 0;
            background: linear-gradient(135deg, var(--primary) 0%, #1e3d6f 100%);
            color: white;
        }

        .contact-form {
            background: rgba(255, 255, 255, 0.1);
            padding: 40px;
            border-radius: 12px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .form-control {
            background: rgba(255, 255, 255, 0.2);
            border: none;
            border-radius: 8px;
            color: white;
            padding: 12px 15px;
            margin-bottom: 20px;
        }

        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.7);
        }

        .form-control:focus {
            background: rgba(255, 255, 255, 0.3);
            color: white;
            box-shadow: 0 0 0 0.25rem rgba(255, 255, 255, 0.25);
            border: 1px solid rgba(255, 255, 255, 0.5);
        }

        footer {
            background-color: #1a252f;
            color: white;
            padding: 60px 0 30px;
        }

        .social-icons a {
            color: white;
            font-size: 1.3rem;
            margin: 0 10px;
            transition: color 0.3s;
        }

        .social-icons a:hover {
            color: var(--accent);
        }

        .stats-card {
            background: white;
            border-radius: 10px;
            padding: 30px;
            text-align: center;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            transition: all 0.3s;
            height: 100%;
            border-top: 4px solid var(--primary);
        }

        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.15);
        }

        .stats-number {
            font-size: 2.5rem;
            font-weight: 800;
            margin-bottom: 10px;
            color: var(--primary);
        }

        .stats-label {
            font-size: 1rem;
            color: #6c757d;
        }

        .feature-icon {
            font-size: 2.5rem;
            color: var(--primary);
            margin-bottom: 20px;
        }

        .feature-box {
            text-align: center;
            padding: 30px 20px;
            border-radius: 10px;
            background: white;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
            transition: all 0.3s;
            height: 100%;
        }

        .feature-box:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
        }

        .contact-info-box {
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            padding: 30px;
            text-align: center;
            margin-bottom: 30px;
            transition: all 0.3s;
        }

        .contact-info-box:hover {
            background: rgba(255, 255, 255, 0.15);
            transform: translateY(-5px);
        }

        @media screen and (max-width: 768px) {
            .hero-title {
                font-size: 2.5rem;
            }

            .hero-subtitle {
                font-size: 1.2rem;
            }

            .history-timeline:before {
                left: 31px;
            }

            .history-item {
                width: 100%;
                padding-left: 70px;
                padding-right: 25px;
                left: 0 !important;
                text-align: left !important;
            }

            .history-item:after {
                left: 18px !important;
            }

            .history-item:nth-child(even):after {
                left: 18px;
            }
        }
    </style>
</head>
<body>
<!-- Navigation -->
<nav class="navbar navbar-expand-lg navbar-light fixed-top">
    <div class="container">
        <a class="navbar-brand" href="#">John <span>Housing</span></a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <li class="nav-item">
                    <a class="nav-link" href="#about">About</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#services">Services</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#properties">Properties</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#history">History</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#testimonials">Testimonials</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="#contact">Contact</a>
                </li>
            </ul>
        </div>
    </div>
</nav>

<!-- Hero Section -->
<section class="hero-section">
    <div class="container">
        <h1 class="hero-title">Find Your Dream Home With Us</h1>
        <p class="hero-subtitle">John Housing connects you with exceptional properties and provides comprehensive real estate services for buyers, sellers, and investors.</p>
        <a href="#properties" class="btn btn-primary-custom btn-lg me-3">Browse Properties</a>
        <a href="#contact" class="btn btn-secondary-custom btn-lg">Get a Consultation</a>
    </div>
</section>

<!-- About Section -->
<section id="about" class="about-section">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-5 mb-lg-0">
                <h2 class="section-title">About John Housing</h2>
                <p class="lead">We are a full-service real estate company dedicated to helping clients navigate the housing market with expertise and integrity.</p>
                <p>Founded in 2005 by John Harrison, our company has grown from a small local agency to a comprehensive real estate service provider with a reputation for excellence, transparency, and client satisfaction.</p>
                <p>Our team of experienced agents, property managers, and real estate specialists work together to ensure every client finds the perfect property or achieves their real estate goals.</p>
                <a href="#services" class="btn btn-primary-custom mt-3">Our Services</a>
            </div>
            <div class="col-lg-6">
                <img src="https://images.pexels.com/photos/1571460/pexels-photo-1571460.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Modern home interior" class="img-fluid rounded shadow">
            </div>
        </div>

        <!-- Stats Section -->
        <div class="row mt-5 pt-5">
            <div class="col-md-3 mb-4">
                <div class="stats-card">
                    <div class="stats-number">1,250+</div>
                    <div class="stats-label">Properties Sold</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stats-card">
                    <div class="stats-number">18+</div>
                    <div class="stats-label">Years Experience</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stats-card">
                    <div class="stats-number">50+</div>
                    <div class="stats-label">Expert Agents</div>
                </div>
            </div>
            <div class="col-md-3 mb-4">
                <div class="stats-card">
                    <div class="stats-number">98%</div>
                    <div class="stats-label">Client Satisfaction</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section id="services" class="services-section">
    <div class="container">
        <h2 class="section-title text-center">Our Services</h2>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-home"></i>
                    </div>
                    <h4>Property Sales</h4>
                    <p>Comprehensive buying and selling services with expert market analysis, pricing strategies, and negotiation.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-building"></i>
                    </div>
                    <h4>Property Management</h4>
                    <p>Full-service management for rental properties including tenant screening, maintenance, and financial reporting.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h4>Real Estate Investment</h4>
                    <p>Investment analysis, portfolio management, and strategic advice for real estate investors.</p>
                </div>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h4>Relocation Services</h4>
                    <p>Assistance with domestic and international relocation including neighborhood analysis and school district information.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-file-contract"></i>
                    </div>
                    <h4>Legal & Documentation</h4>
                    <p>Expert handling of contracts, disclosures, and all necessary paperwork for smooth transactions.</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="service-card text-center p-4">
                    <div class="service-icon">
                        <i class="fas fa-search-dollar"></i>
                    </div>
                    <h4>Market Analysis</h4>
                    <p>Detailed property valuations, market trends analysis, and investment opportunity assessments.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Properties Section -->
<section id="properties" class="properties-section">
    <div class="container">
        <h2 class="section-title text-center">Featured Properties</h2>
        <div class="row">
            <div class="col-md-4 mb-4">
                <div class="property-card">
                    <img src="https://images.pexels.com/photos/106399/pexels-photo-106399.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Modern House" class="property-img">
                    <div class="p-4">
                        <h4>Modern Family Home</h4>
                        <p class="text-muted">Suburban neighborhood, 4 bedrooms, 3 bathrooms</p>
                        <div class="property-price">$850,000</div>
                        <div class="d-flex justify-content-between mt-3">
                            <span class="property-feature"><i class="fas fa-bed me-1"></i> 4 Beds</span>
                            <span class="property-feature"><i class="fas fa-bath me-1"></i> 3 Baths</span>
                            <span class="property-feature"><i class="fas fa-ruler-combined me-1"></i> 2,800 sqft</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="property-card">
                    <img src="https://images.pexels.com/photos/1396122/pexels-photo-1396122.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="City Apartment" class="property-img">
                    <div class="p-4">
                        <h4>Downtown Luxury Apartment</h4>
                        <p class="text-muted">City center, 2 bedrooms, 2 bathrooms</p>
                        <div class="property-price">$650,000</div>
                        <div class="d-flex justify-content-between mt-3">
                            <span class="property-feature"><i class="fas fa-bed me-1"></i> 2 Beds</span>
                            <span class="property-feature"><i class="fas fa-bath me-1"></i> 2 Baths</span>
                            <span class="property-feature"><i class="fas fa-ruler-combined me-1"></i> 1,500 sqft</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="property-card">
                    <img src="https://images.pexels.com/photos/280222/pexels-photo-280222.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Investment Property" class="property-img">
                    <div class="p-4">
                        <h4>Investment Property Duplex</h4>
                        <p class="text-muted">Established neighborhood, 6 units total</p>
                        <div class="property-price">$1,200,000</div>
                        <div class="d-flex justify-content-between mt-3">
                            <span class="property-feature"><i class="fas fa-building me-1"></i> 6 Units</span>
                            <span class="property-feature"><i class="fas fa-car me-1"></i> 12 Parking</span>
                            <span class="property-feature"><i class="fas fa-calendar me-1"></i> Built 2015</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="text-center mt-4">
            <a href="#contact" class="btn btn-primary-custom btn-lg">View All Properties</a>
        </div>
    </div>
</section>

<!-- History Section -->
<section id="history" class="history-section">
    <div class="container">
        <h2 class="section-title text-center" style="color: white;">Our History</h2>
        <div class="history-timeline">
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2005</div>
                    <h4>Company Foundation</h4>
                    <p>John Harrison founds John Housing with a focus on personalized real estate services in the local market.</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2010</div>
                    <h4>Expansion</h4>
                    <p>Expanded services to include property management and opened a second office location.</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2014</div>
                    <h4>Digital Transformation</h4>
                    <p>Launched comprehensive online platform for property listings and virtual tours.</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2018</div>
                    <h4>Investment Division</h4>
                    <p>Established real estate investment advisory services for institutional and individual investors.</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2021</div>
                    <h4>Statewide Coverage</h4>
                    <p>Expanded operations statewide with 5 office locations and 50+ agents.</p>
                </div>
            </div>
            <div class="history-item">
                <div class="history-content">
                    <div class="year-badge">2023</div>
                    <h4>Innovation Award</h4>
                    <p>Received "Most Innovative Real Estate Company" award for our digital client experience.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section id="testimonials" class="testimonials-section">
    <div class="container">
        <h2 class="section-title text-center">Client Testimonials</h2>
        <div class="row">
            <div class="col-md-4">
                <div class="testimonial-card">
                    <img src="https://images.pexels.com/photos/2182970/pexels-photo-2182970.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Client testimonial" class="testimonial-img">
                    <h5>Michael & Sarah Johnson</h5>
                    <p class="text-muted">First-time Home Buyers</p>
                    <p class="testimonial-text">"John Housing made our first home purchase stress-free. Their guidance through the entire process was invaluable. We found our dream home within our budget!"</p>
                    <div class="text-warning">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="testimonial-card">
                    <img src="https://images.pexels.com/photos/3777943/pexels-photo-3777943.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Investor testimonial" class="testimonial-img">
                    <h5>Robert Chen</h5>
                    <p class="text-muted">Real Estate Investor</p>
                    <p class="testimonial-text">"The investment analysis provided by John Housing helped me identify properties with excellent ROI potential. Their management services are top-notch."</p>
                    <div class="text-warning">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="testimonial-card">
                    <img src="https://images.pexels.com/photos/3769021/pexels-photo-3769021.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=2" alt="Seller testimonial" class="testimonial-img">
                    <h5>Emily Rodriguez</h5>
                    <p class="text-muted">Property Seller</p>
                    <p class="testimonial-text">"Sold my property for 15% above asking price thanks to their marketing strategy and negotiation skills. Professional service from start to finish."</p>
                    <div class="text-warning">
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                        <i class="fas fa-star"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Contact Section -->
<section id="contact" class="contact-section">
    <div class="container">
        <h2 class="section-title text-center" style="color: white;">Contact Us</h2>
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="contact-form">
                    <form>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="text" class="form-control" placeholder="Your Name" required>
                            </div>
                            <div class="col-md-6">
                                <input type="email" class="form-control" placeholder="Your Email" required>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <input type="tel" class="form-control" placeholder="Phone Number">
                            </div>
                            <div class="col-md-6">
                                <select class="form-control" required>
                                    <option value="" selected disabled>Service Interested In</option>
                                    <option value="buying">Buying a Property</option>
                                    <option value="selling">Selling a Property</option>
                                    <option value="renting">Renting/Property Management</option>
                                    <option value="investing">Real Estate Investment</option>
                                    <option value="other">Other Inquiry</option>
                                </select>
                            </div>
                        </div>
                        <textarea class="form-control" rows="5" placeholder="Your Message" required></textarea>
                        <div class="text-center mt-4">
                            <button type="submit" class="btn btn-secondary-custom btn-lg">Send Message</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="row mt-5">
            <div class="col-md-4 mb-4">
                <div class="contact-info-box">
                    <i class="fas fa-map-marker-alt fa-2x mb-3"></i>
                    <h5>Main Office</h5>
                    <p>123 Real Estate Ave<br>Suite 500<br>Cityville, ST 12345</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="contact-info-box">
                    <i class="fas fa-phone fa-2x mb-3"></i>
                    <h5>Call Us</h5>
                    <p>+1 (555) 123-4567<br>Mon-Fri: 9am-6pm<br>Sat: 10am-4pm</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <div class="contact-info-box">
                    <i class="fas fa-envelope fa-2x mb-3"></i>
                    <h5>Email Us</h5>
                    <p>info@johnhousing.com<br>sales@johnhousing.com<br>support@johnhousing.com</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Footer -->
<footer>
    <div class="container">
        <div class="row">
            <div class="col-md-4 mb-4">
                <h5 class="mb-3">John <span style="color: var(--accent);">Housing</span></h5>
                <p>Your trusted partner in real estate for buying, selling, investing, and property management since 2005.</p>
                <div class="social-icons mt-4">
                    <a href="#"><i class="fab fa-facebook"></i></a>
                    <a href="#"><i class="fab fa-instagram"></i></a>
                    <a href="#"><i class="fab fa-twitter"></i></a>
                    <a href="#"><i class="fab fa-linkedin"></i></a>
                    <a href="#"><i class="fab fa-youtube"></i></a>
                </div>
            </div>
            <div class="col-md-2 mb-4">
                <h5>Quick Links</h5>
                <ul class="list-unstyled">
                    <li class="mb-2"><a href="#about" class="text-light text-decoration-none">About Us</a></li>
                    <li class="mb-2"><a href="#services" class="text-light text-decoration-none">Services</a></li>
                    <li class="mb-2"><a href="#properties" class="text-light text-decoration-none">Properties</a></li>
                    <li class="mb-2"><a href="#testimonials" class="text-light text-decoration-none">Testimonials</a></li>
                </ul>
            </div>
            <div class="col-md-3 mb-4">
                <h5>Services</h5>
                <ul class="list-unstyled">
                    <li class="mb-2"><a href="#" class="text-light text-decoration-none">Buying a Home</a></li>
                    <li class="mb-2"><a href="#" class="text-light text-decoration-none">Selling a Home</a></li>
                    <li class="mb-2"><a href="#" class="text-light text-decoration-none">Property Management</a></li>
                    <li class="mb-2"><a href="#" class="text-light text-decoration-none">Real Estate Investing</a></li>
                </ul>
            </div>
            <div class="col-md-3 mb-4">
                <h5>Newsletter</h5>
                <p class="small">Subscribe for market updates and property listings.</p>
                <div class="input-group mb-3">
                    <input type="email" class="form-control" placeholder="Your Email">
                    <button class="btn btn-primary-custom" type="button">Subscribe</button>
                </div>
            </div>
        </div>
        <hr class="mt-4 mb-4" style="background-color: rgba(255,255,255,0.2);">
        <div class="row">
            <div class="col-md-12 text-center">
                <p>&copy; 2023 John Housing. All rights reserved. | <a href="#" class="text-light text-decoration-none">Privacy Policy</a> | <a href="#" class="text-light text-decoration-none">Terms of Service</a></p>
                <p class="small">Real estate brokerage license #1234567</p>
            </div>
        </div>
    </div>
</footer>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>

<!-- Smooth Scroll -->
<script>
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            document.querySelector(this.getAttribute('href')).scrollIntoView({
                behavior: 'smooth'
            });
        });
    });

    // Navbar background on scroll
    window.addEventListener('scroll', function() {
        if (window.scrollY > 50) {
            document.querySelector('.navbar').style.boxShadow = '0 5px 20px rgba(0, 0, 0, 0.15)';
        } else {
            document.querySelector('.navbar').style.boxShadow = '0 2px 15px rgba(0, 0, 0, 0.1)';
        }
    });
</script>
</body>
</html>
<?php /**PATH /home/homefqlp/public_html/resources/views/landing.blade.php ENDPATH**/ ?>