<?php
    Theme::set('pageTitle', $gallery->name);
?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['section-details pb-100', 'pt-80' => get_header_style() != 2, 'pt-160' => get_header_style() == 2]); ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 mx-lg-auto mb-8">
                <div class="text-center">
                    <h3 class="ds-3 mt-3 text-dark"><?php echo BaseHelper::clean($gallery->name); ?></h3>
                </div>
            </div>
        </div>
        <div class="page-content">
            <article class="post post--single">
                <div class="post__content">
                    <div class="ck-content">
                        <?php echo BaseHelper::clean($gallery->description); ?>

                    </div>
                    <br>
                    <div id="list-photo">
                        <?php $__currentLoopData = gallery_meta_data($gallery); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(! $image) continue; ?>

                            <div
                                class="item"
                                data-src="<?php echo e(RvMedia::getImageUrl($imageUrl = Arr::get($image, 'img'))); ?>"
                                data-sub-html="<?php echo e($description = BaseHelper::clean(Arr::get($image, 'description'))); ?>"
                            >
                                <div class="photo-item">
                                    <div class="thumb">
                                        <a href="<?php echo e($description); ?>">
                                            <?php echo e(RvMedia::image($imageUrl, $description)); ?>

                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <br>
                    <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $gallery); ?>

                </div>
            </article>
        </div>
    </div>
</section>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/views/gallery.blade.php ENDPATH**/ ?>