<section class="section-work">
    <div class="row">
        <div class="card-scroll mt-8">
            <div class="cards">
                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="card-custom" data-index="0">
                        <div class="card__inner bg-6 p-lg-6 p-md-4 p-3">
                            <div class="card__image-container zoom-img position-relative">
                                <?php if($project->image): ?>
                                    <?php echo e(RvMedia::image($project->image, $project->name, attributes: ['class' => 'card__image card_image_square'])); ?>

                                    <a href="<?php echo e($project->url); ?>" class="card-image-overlay position-absolute start-0 end-0 w-100 h-100"></a>
                                <?php endif; ?>
                            </div>
                            <div class="card__content px-md-4 px-3">
                                <div class="card__title d-md-flex align-items-center mb-0 mb-lg-2">
                                    <a href="<?php echo e($project->url); ?>" class="card_title_link">
                                        <?php if($project->categories->isNotEmpty()): ?>
                                            <p class="text-primary mb-0 mb-md-2"><?php echo e($project->categories->map(fn ($item) => $item->name)->join(', ')); ?></p>
                                        <?php endif; ?>
                                        <h3 class="fw-semibold"><?php echo e($project->name); ?></h3>
                                    </a>
                                    <a href="<?php echo e($project->url); ?>" class="card-icon d-none d-md-inline-flex border text-dark border-dark icon-shape ms-auto icon-md rounded-circle">
                                        <i class="ri-arrow-right-up-line"></i>
                                    </a>
                                </div>
                                <?php if($project->description): ?>
                                    <p class="text-300 mb-lg-auto mb-md-4 mb-3">
                                        <?php echo BaseHelper::clean($project->description); ?>

                                    </p>
                                <?php endif; ?>
                                <?php if($project->client): ?>
                                    <div class="d-md-flex content">
                                        <p class="mb-0 fs-7 text-dark text-uppercase w-40"><?php echo e(__('Client')); ?></p>
                                        <p class="mb-0 card__description text-300 fs-6 mb-0"><?php echo e($project->client); ?></p>
                                    </div>
                                <?php endif; ?>
                                <?php if($project->start_date): ?>
                                    <div class="d-md-flex content">
                                        <p class="mb-0 fs-7 text-dark text-uppercase w-40"><?php echo e(__('Start Date')); ?></p>
                                        <p class="mb-0 card__description text-300 fs-6 mb-0"><?php echo e(Theme::formatDate($project->start_date)); ?></p>
                                    </div>
                                <?php endif; ?>
                                <?php if($link = $project->getMetaData('link', true)): ?>
                                    <div class="d-md-flex content">
                                        <p class="mb-0 fs-7 text-dark text-uppercase w-40"><?php echo e(__('Preview')); ?></p>
                                        <a href="<?php echo e($link); ?>" class="mb-0 card__description text-primary fs-6 mb-0"><?php echo e($link); ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/partials/shortcodes/projects/styles/style-4.blade.php ENDPATH**/ ?>