<div class="col">
    <div class="blog-card rounded-4 mb-lg-3 mb-md-5 mb-3">
        <div class="blog-card__image position-relative">
            <div class="zoom-img rounded-3 overflow-hidden">
                <?php echo e(RvMedia::image($post->image, $post->name, 'post-thumbnail')); ?>

                <?php if($post->firstCategory): ?>
                    <a class="position-absolute bottom-0 start-0 m-3 text-white-keep btn btn-gradient fw-medium rounded-3 px-3 py-2" href="<?php echo e($post->firstCategory->url); ?>">
                        <?php echo e($post->firstCategory->name); ?>

                    </a>
                <?php endif; ?>
                <a href="<?php echo e($post->url); ?>" title="<?php echo e($post->name); ?>" class="blog-card__link position-absolute top-50 start-50 translate-middle icon-md icon-shape bg-linear-1 rounded-circle">
                    <i class="ri-arrow-right-up-line text-dark"></i>
                </a>
            </div>
        </div>
        <div class="blog-card__content position-relative text-center mt-4">
            <span class="blog-card__date fs-7"><?php echo e(Theme::formatDate($post->created_at)); ?> • <?php echo e(__(':count min read', ['count' => $post->time_reading])); ?></span>
            <div class="h5 blog-card__title text-truncate"><?php echo BaseHelper::clean($post->name); ?></div>
            <?php if($post->description): ?>
                <p class="blog-card__description fs-6"><?php echo Str::limit(BaseHelper::clean($post->description)); ?></p>
            <?php endif; ?>
            <a href="<?php echo e($post->url); ?>" class="link-overlay position-absolute top-0 start-0 w-100 h-100" title="<?php echo e($post->name); ?>"></a>
        </div>
    </div>
</div>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/views/templates/post-item/style-1.blade.php ENDPATH**/ ?>