<?php if(! empty($tabs)): ?>
    <section class="section-skills-1 position-relative section-padding bg-900">
        <div class="container">
            <div class="row">
                <?php if($shortcode->title || $shortcode->subtitle): ?>
                    <div class="text-center mb-7">
                        <?php if($shortcode->title): ?>
                            <h3 class="ds-3 mt-3 mb-3 text-primary"><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                        <?php endif; ?>
                        <?php if($shortcode->subtitle): ?>
                            <span class="fs-5 fw-medium text-200">
                            <?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?>

                        </span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <div class="d-flex flex-wrap flex-lg-nowrap justify-content-center gap-0 gap-lg-3 mb-7 px-4 px-lg-6">
                    <?php $__currentLoopData = $tabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="skills">
                            <div class="skills-icon mb-5">
                                <?php echo e(RvMedia::image($tab['image'], $tab['name'], 'thumb')); ?>

                            </div>
                            <div class="skills-ratio text-center">
                                <?php
                                    preg_match('/(\d+)(\D+)/', $tab['level'], $matches);
                                    $number = $matches[1] ?? 0;
                                    $unit = $matches[2] ?? '';
                                ?>
                                <h3 class="count fw-semibold my-0"><span class="odometer fw-semibold" data-count="<?php echo e($number); ?>"></span><?php echo e($unit); ?></h3>
                                <p class="text-400 fw-medium text-uppercase"><?php echo BaseHelper::clean($tab['name']); ?></p>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php if($shortcode->extra_content): ?>
                    <div class="text-center">
                        <p class="fs-5 text-200 mb-0">
                            <?php echo BaseHelper::clean(nl2br($shortcode->extra_content)); ?>

                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/partials/shortcodes/skills/styles/style-1.blade.php ENDPATH**/ ?>