<?php
    Theme::set('pageTitle', __('Galleries'));

    Gallery::registerAssets();
?>

<section class="<?php echo \Illuminate\Support\Arr::toCssClasses(['section-details pb-100', 'pt-80' => get_header_style() != 2, 'pt-160' => get_header_style() == 2]); ?>">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 mx-lg-auto mb-8">
                <div class="text-center">
                    <h3 class="ds-3 mt-3 text-dark"><?php echo e(__('Galleries')); ?></h3>
                </div>
            </div>
        </div>
        <div class="page-content">
            <article class="post post--single">
                <div class="post__content">
                    <?php if(isset($galleries) && $galleries->isNotEmpty()): ?>
                        <div class="gallery-wrap">
                            <?php $__currentLoopData = $galleries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gallery): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="gallery-item">
                                    <div class="img-wrap">
                                        <a href="<?php echo e($gallery->url); ?>">
                                            <?php echo e(RvMedia::image($gallery->image, $gallery->name, 'medium')); ?>

                                        </a>
                                    </div>
                                    <div class="gallery-detail">
                                        <div class="gallery-title">
                                            <a href="<?php echo e($gallery->url); ?>"><?php echo e($gallery->name); ?></a>
                                        </div>
                                        <?php if(trim($gallery->user->name)): ?>
                                            <div class="gallery-author"><?php echo e(__('By :name', ['name' => $gallery->user->name])); ?></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </article>
            <div class="clearfix"></div>
        </div>
    </div>
</section>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/views/galleries.blade.php ENDPATH**/ ?>