<section class="section-service-1 pt-120 pb-120">
    <div class="container">
        <div class="row align-items-end">
            <?php if($shortcode->title || $shortcode->subtitle): ?>
                <div class="col-lg-7 me-auto">
                    <?php if($shortcode->title): ?>
                        <h3 class="ds-3 mt-3 mb-3 text-primary"><?php echo BaseHelper::clean($shortcode->title); ?></h3>
                    <?php endif; ?>
                    <?php if($shortcode->subtitle): ?>
                        <span class="fs-5 fw-medium text-200">
                            <?php echo BaseHelper::clean(nl2br($shortcode->subtitle)); ?>

                        </span>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <?php if($shortcode->action_text): ?>
                <div class="col-lg-auto">
                    <a href="<?php echo e($shortcode->action_link); ?>" class="btn btn-gradient mt-lg-0 mt-5 ms-lg-auto">
                        <?php echo e($shortcode->action_text); ?>

                        <i class="ri-arrow-right-up-line"></i>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <div class="row mt-6 justify-content-between">
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-12">
                    <div
                        class="single-service-card-1 <?php if($shortcode->show_image_on_hover != 'no'): ?> tg-img-reveal-item <?php endif; ?> w-100 border-top border-900 p-3"
                        data-fx="1"
                        <?php if($service->image && ($shortcode->show_image_on_hover != 'no')): ?> data-img="<?php echo e(RvMedia::getImageUrl($service->image)); ?>" <?php endif; ?>
                    >
                        <div class="service-card-details d-lg-flex align-items-center">
                            <h3 class="service-card-title w-lg-50 w-100 mb-0">
                                <a href="<?php echo e($service->url); ?>">
                                    <span class="service-number">
                                        <?php echo e(Str::padLeft($loop->iteration, 2, 0)); ?>.
                                    </span>
                                    <?php echo e($service->name); ?>

                                </a>
                            </h3>
                            <a href="<?php echo e($service->url); ?>" class="d-md-flex d-block ps-lg-10 align-items-center justify-content-end w-100">
                                <?php if($service->description): ?>
                                    <p class="service-card-text my-3">
                                        <?php echo BaseHelper::clean(nl2br($service->description)); ?>

                                    </p>
                                <?php endif; ?>
                                <div class="service-card-icon icon-shape ms-auto icon-md rounded-circle border">
                                    <i class="ri-arrow-right-up-line"></i>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/partials/shortcodes/services/styles/style-1.blade.php ENDPATH**/ ?>