<?php
    Theme::set('pageTitle', $service->name);
?>

<section class="section-work-single section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-lg-auto mb-lg-0 pb-8">
                <div class="text-center">
                    <div class="btn btn-gradient d-inline-block text-uppercase"><?php echo e(__('Service')); ?></div>
                    <h3 class="ds-3 mt-3 mb-4 text-dark"><?php echo BaseHelper::clean($service->name); ?></h3>
                    <p class="text-300 fs-5 mb-0"><?php echo BaseHelper::clean(nl2br($service->description)); ?></p>
                </div>
            </div>
            <?php if($service->image): ?>
                <?php echo e(RvMedia::image($service->image, $service->name)); ?>

            <?php endif; ?>
            <div class="col-lg-8 mx-lg-auto mt-8">
                <div class="ck-content"><?php echo BaseHelper::clean($service->content); ?></div>
                <div class="border-linear-3 rounded-4 p-lg-6 p-md-4 p-3 my-4">
                    <span class="text-uppercase fs-7 me-2"><?php echo e(__('Share')); ?></span> <br />
                    <?php echo Theme::renderSocialSharing($service->url, SeoHelper::getDescription(), $service->image); ?>

                </div>
                <?php echo apply_filters(BASE_FILTER_PUBLIC_COMMENT_AREA, null, $service); ?>

            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/homefqlp/public_html/platform/themes/zelio/views/portfolio/service.blade.php ENDPATH**/ ?>